*     *****************************************************************        *;
*     *****************************************************************        *;
*   File-Name:   envsci.do	                                                   *;
*   Date:        June 2020			                                           *;
*   Authors:     Kural, Dellmuth, Gustafsson			                       *;
*   Purpose:     Replicate results for paper in ENVSCI 2020		               *; 
*   Input Files: envsci.dta               	                                   *; 
*     *****************************************************************        *;
*     *****************************************************************        *;



**********************************************************************************
**Prepare data for making figures 1 and 2
**********************************************************************************

preserve 

gen time=.
replace time=0 if year<=2007
replace time=1 if year>=2008&year<=2017
collapse (sum) response_no (sum) statement (sum) event (sum) framework (sum) ///
fund (sum) operational (sum) reports (sum) inst, by(IGO time)
drop if time==.
tab IGO
tab IGO, nol

label define time 0 "1997-2007" 1 "2008-2017", modify
label values time time


**********************************************************************************
**MAKE FIGURE 1
**********************************************************************************
set scheme plotplain

gen responses=response_no-event

// Ece this seems to be a larger sample than in the paper

graph hbar (sum) responses, over(time, label(labsize(vsmall))) ///
over(IGO, sort(2) descending  ///
label(labsize(small))) ytitle("Sum of Governance Responses") ///
asyvars blabel(bar, position(outside) format(%9.1f) size(vsmall)) ///
bar(2, fcolor(Grayscale6)) ///
saving(fig1.gph, replace)



**********************************************************************************
**MAKE FIGURE 2
**********************************************************************************

preserve 
*Add UNICEF/WHO for t==0 //Ece can this line be deleted?

gen pstatement=statement/responses
gen pframework=framework/responses 
gen poperational=operational/responses
gen pinst=inst/responses
gen preports=reports/responses
gen pfund=fund/responses
gen pstateframe=pframework+pstatement
collapse pstateframe pstatement pframework pfund pinst poperational preports, by(time)
graph bar pstateframe preports pfund pinst poperational , ///
ylab(0 "0%" .25 "25%" .5 "50%" .75 "75%" 1 "100%") over(time) stack ///
legend(col(1) lab(1 "Declarations and statements") ///
lab(2 "Publication of reports") lab(3 "Funding or fund creation") lab(4 "Institution building") ///
lab(5 "Projects and programs")) ///
saving(fig2.gph, replace) 

restore 

**********************************************************************************
**FIGURE A1
**********************************************************************************


preserve
set scheme lean2

drop if year <1997

collapse (sum) response_no IGO, by(year)

twoway line response_no year , ytitle("Sum of Governance Responses") xtitle("Year") xlabel(1997(1)2017) xlabel(, angle(45)) ylabel(0(20)120) ///
saving(figA1.gph, replace)


restore


**********************************************************************************
** FIGURE A2
**********************************************************************************

preserve 

set scheme lean2
**UNHCR
keep if IGO==23

gen responses=response_no-event

gen pstatement=statement/responses
gen pframework=framework/responses 
gen poperational=operational/responses
gen pinst=inst/responses
gen preports=reports/responses
gen pfund=fund/responses
gen pstateframe=pframework+pstatement

collapse pstateframe pstatement pframework pfund pinst poperational preports

graph bar pstateframe preports pfund pinst poperational , ///
legend(col(3) position (6) lab(1 "Declarations and statements") /// 
lab(2 "Publication of reports") lab(3 "Funding or fund creation") lab(4 "Institution building") ///
lab(5 "Projects and programs")) ///
ylab(0 "0%" .25 "25%" .5 "50%" .75 "75%" 1 "100%") stack ///
blabel(%, size(vsmall)) ///
title("UNHCR") ///
saving(figA2_UNHCR.gph, replace) 

restore 

*WHO
preserve

set scheme s1manual
keep if IGO==31
gen responses=response_no-event

gen pstatement=statement/responses
gen pframework=framework/responses 
gen poperational=operational/responses
gen pinst=inst/responses
gen preports=reports/responses
gen pfund=fund/responses
gen pstateframe=pframework+pstatement

collapse pstateframe pstatement pframework pfund pinst poperational preports

graph bar pstateframe preports pfund pinst poperational , ///
legend(col(3) position (6) lab(1 "Declarations and statements") /// 
lab(2 "Publication of reports") lab(3 "Funding or fund creation") lab(4 "Institution building") ///
lab(5 "Projects and programs")) ///
ylab(0 "0%" .25 "25%" .5 "50%" .75 "75%" 1 "100%") stack ///
blabel(%, size(vsmall)) ///
title("WHO") ///
saving(figA2_WHO.gph, replace) 

restore 


*UNEP
preserve
set scheme s1manual
keep if IGO==33
gen responses=response_no-event
gen pstatement=statement/responses
gen pframework=framework/responses 
gen poperational=operational/responses
gen pinst=inst/responses
gen preports=reports/responses
gen pfund=fund/responses
gen pstateframe=pframework+pstatement

collapse pstateframe pstatement pframework pfund pinst poperational preports

graph bar pstateframe preports pfund pinst poperational, ///
legend(col(3) position (6) lab(1 "Declarations and statements") /// 
lab(2 "Publication of reports")  lab(3 "Funding or fund creation") lab(4 "Institution building") ///
lab(5 "Projects and programs")) ///
ylab(0 "0%" .25 "25%" .5 "50%" .75 "75%" 1 "100%") stack ///
blabel(%, size(vsmall)) ///
title("UN Environment") ///
saving(figA2_UNEP.gph, replace) 

restore 

grc1leg2 figA2_UNHCR.gph figA2_WHO.gph figA2_UNEP.gph, cols(3)

**********************************************************************************
** FIGURE A3
**********************************************************************************

preserve 

keep if IGO==33 | IGO==31 | IGO==23


collapse (sum) response_no (sum) statement (sum) event (sum) framework (sum) ///
fund (sum) operational (sum) reports (sum) inst, by(IGO year)


gen frame=framework+statement

foreach var of varlist fund-frame {
by IGO, sort : egen float `var'sum1 = sum(`var') if tin(1997, 2001)
by IGO, sort : egen float `var'sum2 = sum(`var') if tin(2002, 2006)
by IGO, sort : egen float `var'sum3 = sum(`var') if tin(2007, 2011)
by IGO, sort : egen float `var'sum4 = sum(`var') if tin(2012, 2017)
label variable `var'sum1 "2001"
label variable `var'sum2 "2006"
label variable `var'sum3 "2011"
label variable `var'sum4 "2017"
replace `var'sum1=`var'sum2 if `var'sum1==.
replace `var'sum1=`var'sum3 if `var'sum1==.
replace `var'sum1=`var'sum4 if `var'sum1==.
}

gen responses=response_no-event
gen pframesum1=framesum1/responses
gen pfundsum1=fundsum1/responses 
gen poperationalsum1=operationalsum1/responses
gen preportssum1=reportssum1/responses
gen pinstsum1=instsum1/responses


graph bar pframesum1-pinstsum1, over(year) over(IGO) ///
legend(col(3) position (6) lab(1 "Declarations and statements") /// 
lab(2 "Publication of reports") lab(3 "Funding or fund creation") lab(4 "Institution building") ///
lab(5 "Projects and programs")) ///
 stack ///
blabel(%, size(vsmall)) ///
title("Percentage of Different Types of Adaptation Activities Organized across UNHCR, WHO and UN Environment") 





